/*
 * Reader.h
 *
 *  Created on: 18.07.2011
 *      Author: stefan.detter
 */

#ifndef READER_H_
#define READER_H_

#include <QObject>

#include <QrfeTraceModule>
#include <QrfeReaderInterface>
#include <QrfeReaderInterfaceGlobal>

#include <def.h>

#include "event/Events.h"

class Pipe;

class Reader : public QObject, QrfeTraceModule
{
	Q_OBJECT

public:
	Reader(QrfeReaderInterface* reader, QObject* parent = 0);
	virtual ~Reader();

	Pipe*					pipe();
	QrfeReaderInterface* 	readerInterface();

public:
	QString 					name() const;
	QString 					readerId() const;
	QString 					serialNumber() const;
	ulong 						serialNumberExact() const;
	QrfeGlobal::ReaderType		readerType() const;
	ulong 						readerTypeExact() const;
	QString						readerTypeExactString() const;
	QrfeGlobal::ReaderModule	readerModule() const;
	QString						readerModuleString() const;
	QrfeGlobal::TagType			tagType() const;
	QString 					tagTypeString() const;
	ulong 						hardwareRevision() const;
	QString 					hardwareRevisionString() const;
	ulong 						softwareRevision() const;
	QString						softwareRevisionString() const;
	QString 					advancedSoftwareRevisionString() const;
	ulong 						bootloaderRevision() const;
	QString						bootloaderRevisionString() const;
	QrfeGlobal::HandlerState 	currentState() const;
	QString 					currentStateString() const;
	QrfeGlobal::HandlerAction 	currentAction() const;
	QString 					currentActionString() const;
	QrfeGlobal::ReaderSystem	currentSystem() const;
	QString						currentSystemString() const;
	qulonglong					statusRegister() const;
	QStringList					statusRegisterBitDescriptions() const;
	ulong						gpioValues() const;
	uchar 						antennaCount() const;
	QString						deviceName() const;
	QrfeGlobal::DeviceType		deviceType() const;
	ulong  						readerCaps() const;
	ulong  						tagFunctionCaps() const;
	QString 					readerName() const;
	QString 					readerLocation() const;

	QrfeGlobal::Result 			readSettings( );


public slots:
	void startPipe ( );
	void stopPipe ( );

    void pausePipe (  );
    void continuePipe (  );

	void destroy();

    void notificationSlot ( uchar id, const QVariant& value );
    void cyclicInventorySlot ( const QrfeGlobal::TagReadEvent& tag );

signals:
	void heartBeat();
    void notification ( const uchar id, const QString& idStr, const QVariant& value );
    void signatureChanged();
    void tagTypeChanged(int type);
	void changedState(int state);
	void changedAction(int action);
	void changedStatusRegister(qulonglong statusRegister);
	void changedGpioValues(ulong);
	void changedRssiEnable(bool on, uchar rssiChildCount, const QStringList& rssiChildNames, int rssiChildMin, int rssiChildMax);
	void changedReadFrequencyEnable(bool);
	void changedReaderName(const QString& name);
	void changedReaderLocation(const QString& location);
	void requestForDelete();
    void lostConnection();

    void inventoryAboutToStart();
    void inventoryStarted();
    void inventoryStoped();
    void inventoryPaused();
    void inventoryContinued();
    void tagEvent(const TagEvent& event);
	void infoEvent(const InfoEvent& event);

private:
	void initInstance();

private:
	QrfeReaderInterface* 	m_reader;

	static int 				m_instanceCount;

	QList<QString> 			m_rssiChannelName;
	QList<long> 			m_rssiChannelMaximum;
	QList<long> 			m_rssiChannelMinimum;
	QList<QString> 			m_rssiChannelUnits;
};

#endif /* READER_H_ */
